<?php

/*
 * Plugin Name: SB Divi Contact Form DB
 * Plugin URI:  http://www.sean-barton.co.uk
 * Description: A simple plugin to save contact form submissions in the database
 * Author:      Sean Barton - Tortoise IT
 * Version:     1.5
 * Author URI:  http://www.sean-barton.co.uk
 *
 * Changelog:
 *
 * < V1.0
 * - Initial Version
 *
 * V1.1 - 10/8/17
 * - Removed some CSS causing the pagination to not function
 *
 * V1.2 - 03/11/17
 * - Added export functionality (finally)
 * - Added licensing and auto update
 *
 * V1.3 - 05/12/17
 * - Fixed export function. It was previously exporting only 5 rows. This removes that limit
 *
 * V1.4 - 08/02/18
 * - Added a 'hide admin nag' option on the new settings page. This removes the red bar at the top if you don't want it.
 *
 * V1.5 - 12/02/18
 * - Fixed export dropdown for those sites that have more than 3/5 forms to track.
 *
 */

//constants
define('SB_DIVI_DB_VERSION', '1.5');
define('SB_DIVI_DB_STORE_URL', 'https://elegantmarketplace.com');
define('SB_DIVI_DB_ITEM_NAME', 'Divi Form DB');
define('SB_DIVI_DB_AUTHOR_NAME', 'Sean Barton');
define('SB_DIVI_DB_ITEM_ID', 172927);
define('SB_DIVI_DB_FILE', __FILE__);

require_once('includes/emp-licensing.php');

add_action('plugins_loaded', 'sb_divi_cfd_init');

function sb_divi_cfd_init()
{
    add_action('admin_enqueue_scripts', 'sb_divi_cfd_css_enqueue', 9999);

    add_filter('et_contact_page_headers', 'sb_divi_cfd_et_contact_page_headers', 10, 10);
    add_action('add_meta_boxes', 'sb_divi_cfd_register_meta_box');
    add_action('init', 'sb_divi_cfd_pt_init');
    add_action('admin_notices', 'sb_divi_cfd_admin_notice');
    add_action('admin_head', 'sb_divi_cfd_admin_head');
    add_action('admin_init', 'sb_divi_cfd_download_csv', 1, 1);
    add_action('admin_menu', 'sb_divi_cfd_submenu');

    add_filter('manage_divi_cf_db_posts_columns', 'sb_divi_cfd_columns_head', 100);
    add_action('manage_divi_cf_db_posts_custom_column', 'sb_divi_cfd_columns_content', 100, 2);
}

function sb_divi_cfd_submenu()
{
    add_submenu_page(
        'edit.php?post_type=divi_cf_db',
        'Export',
        'Export',
        'manage_options',
        'sb_divi_cfd',
        'sb_divi_cfd_submenu_cb');

    add_submenu_page(
        'edit.php?post_type=divi_cf_db',
        'Settings',
        'Settings',
        'manage_options',
        'sb_divi_cfd_settings',
        'sb_divi_cfd_settings_submenu_cb');

    add_submenu_page(
        'edit.php?post_type=divi_cf_db',
        'Licensing',
        'Licensing',
        'manage_options',
        'sb_divi_cfd_license',
        'sb_divi_cfd_license_submenu_cb');
}

function sb_divi_cfd_license_submenu_cb()
{

    echo '<div class="wrap"><div id="icon-tools" class="icon32"></div>';
    echo '<h2>' . SB_DIVI_DB_ITEM_NAME . ' - Version ' . SB_DIVI_DB_VERSION . '</h2>';

    echo '<div id="poststuff">';

    echo '<div id="post-body" class="metabox-holder columns-2">';

    echo '<form method="POST">';

    sb_divi_db_license_page();

    echo '</form>';

    echo '</div>';
    echo '</div>';

    echo '</div>';
}

function sb_divi_cfd_box_start($title)
{
    return '<div class="postbox">
                    <h2 class="hndle">' . $title . '</h2>
                    <div class="inside">';
}

function sb_divi_cfd_download_csv()
{

    if (isset($_REQUEST['download_csv'])) {
        if (isset($_REQUEST['form_name'])) {
            if ($rows = sb_divi_cfd_get_export_rows($_REQUEST['form_name'])) {

                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename=' . sanitize_title($_REQUEST['form_name']) . '.csv');
                header('Pragma: no-cache');
                echo implode("\n", $rows);
                die;
            }
        }
    }
}

function sb_divi_cfd_box_end()
{
    return '    </div>
                </div>';
}


function sb_divi_cfd_submenu_cb()
{

    echo '<div class="wrap"><div id="icon-tools" class="icon32"></div>';
    echo '<h2>' . SB_DIVI_DB_ITEM_NAME . ' - Version ' . SB_DIVI_DB_VERSION . '</h2>';

    echo '<div id="poststuff">';

    echo '<div id="post-body" class="metabox-holder columns-2">';

    echo sb_divi_cfd_box_start('Export Results');

    echo '<p>Use this simple form to export your contact data to CSV file. This is fairly crude but we don\'t have names for forms but we do have the page it was submitted from.. often the page the form is on. The plugin only supports the first form on each page anyway so you vcan generally assume that, for example, the form called "Contact" is your contact form and the one called "Work with me" would be your enquiry form.</p>';

    if ($posts = get_posts('post_type=divi_cf_db&posts_per_page=-1')) {
        $forms = array();
        foreach ($posts as $post) {
            if ($data = get_post_meta($post->ID, 'sb_divi_cfd', true)) {
                $forms[$data['extra']['submitted_on']] = $data['extra']['submitted_on'];
            }
        }

        echo '<form method="POST">';
        echo '<h3>Select a form to export:</h3>';
        echo '<select  style="margin-right: 10px; width: 200px;" name="form_name">';

        $alpha_forms = array();
        foreach ($forms as $form) {
            $alpha_forms[$form] = $form;
        }

        ksort($alpha_forms);
        foreach ($alpha_forms as $form) {
            echo '<option ' . (isset($_REQUEST['form_name']) && $_REQUEST['form_name'] == $form ? 'selected="selected"' : '') . ' value="' . $form . '">' . $form . '</option>';
        }

        echo '</select>';
        echo '<input type="submit" name="" class="button-primary" value="Export Form" />';
        echo '</form>';

        if (isset($_REQUEST['form_name'])) {

            $rows = sb_divi_cfd_get_export_rows($_REQUEST['form_name']);

            echo '<h3>CSV Content</h3>';
            echo '<div style="margin-top: 20px; min-height: 150px; max-height: 350px; overflow: scroll; margin-bottom: 10px; border: 1px solid #EEE; padding: 20px;">' . implode('<br />', $rows) . '</div>';

            echo '<form method="POST">';
            echo '<input type="hidden" name="form_name" value="' . $_REQUEST['form_name'] . '" />';
            echo '<input type="submit" name="download_csv" class="button-primary" value="Download CSV File" />';
            echo '</form>';
        }
    } else {
        echo '<p>This page will show a form when you have at least one submission. Until then, enjoy this picture of a cat!</p>';
        echo '<img src="http://placekitten.com/g/500/500" />';
    }

    echo sb_divi_cfd_box_end();

    echo '</div>';

    echo '</div>';
    echo '</div>';
}

function sb_divi_cfd_settings_submenu_cb()
{

    echo '<div class="wrap"><div id="icon-tools" class="icon32"></div>';
    echo '<h2>' . SB_DIVI_DB_ITEM_NAME . ' - Version ' . SB_DIVI_DB_VERSION . '</h2>';

    echo '<div id="poststuff">';

    echo '<div id="post-body" class="metabox-holder columns-2">';

    if (isset($_POST['sb_divi_cfd_save'])) {
        //echo 'updating';
        update_option('sb_divi_cfd', @$_POST['sb_divi_cfd']);

        echo '<div id="message" class="updated fade"><p>Settings saved successfully</p></div>';
    }

    $sb_divi_cfd = get_option('sb_divi_cfd');

    echo sb_divi_cfd_box_start('Settings');

    echo '<p>This simple form will provide some handy switches and settings for the plugin.</p>';


    echo '<form method="POST">';

    echo '<p>
                <label><input type="checkbox" name="sb_divi_cfd[disable_admin_nag]" ' . checked(1, (isset($sb_divi_cfd['disable_admin_nag']) ? 1 : 0), false) . ' value="1" /> Disable Admin Nag?</label>
                <br /><small>The admin nag is the red box that shows at the top of your admin pages when there is a contact submission to review. If you would prefer to use the plugin as a backup only then just check this box to turn the nag off..</small>
            </p>';


    echo '<input type="submit" name="sb_divi_cfd_save" class="button-primary" value="Save Settings" />';
    echo '</form>';

    echo sb_divi_cfd_box_end();

    echo '</div>';

    echo '</div>';
    echo '</div>';
}

function sb_divi_cfd_get_export_rows($form_name)
{
    $rows = array();

    if ($posts = get_posts('post_type=divi_cf_db&posts_per_page=-1')) {
        $row = '';
        $row .= '"Date","Submitted On","Submitted By",';

        foreach ($posts as $post) {
            if ($data = get_post_meta($post->ID, 'sb_divi_cfd', true)) {
                if ($data['extra']['submitted_on'] == $form_name) {
                    foreach ($data['data'] as $field) {
                        $row .= '"' . $field['label'] . '",';
                    }
                    break; //looking for the first instance of this form.
                }
            }
        }

        $rows[] = rtrim($row, ',');

        foreach ($posts as $post) {
            if ($data = get_post_meta($post->ID, 'sb_divi_cfd', true)) {
                if ($data['extra']['submitted_on'] == $form_name) {
                    $row = '';
                    $row .= '"' . $post->post_date . '","' . $data['extra']['submitted_on'] . '","' . $data['extra']['submitted_by'] . '",';

                    foreach ($data['data'] as $field) {
                        $row .= '"' . addslashes($field['value']) . '",';
                    }

                    $rows[] = rtrim($row, ',');
                }
            }
        }
    }

    return $rows;
}

function sb_divi_cfd_css_enqueue()
{
    global $current_screen;

    if ($current_screen->id == 'divi_cf_db') {
        wp_enqueue_script('sb_divi_cfd_js', plugins_url('/script.js', __FILE__));
    }
}

function sb_divi_cfd_columns_head($defaults)
{
    unset($defaults['date']);
    unset($defaults['cb']);
    unset($defaults['title']);

    $defaults['cf_divi_title'] = 'View';
    $defaults['email'] = 'Email';
    $defaults['read'] = 'Read/Unread';
    $defaults['cloned'] = 'Cloned';
    $defaults['sub_on'] = 'Submitted On';
    $defaults['sub_date'] = 'Submission Date';

    return $defaults;
}

// SHOW THE FEATURED IMAGE
function sb_divi_cfd_columns_content($column_name, $post_id)
{
    $contact = get_post($post_id);
    $data = get_post_meta($post_id, 'sb_divi_cfd', true);

    if ($column_name == 'cf_divi_title') {
        echo '<a href="' . admin_url('post.php?action=edit&post=' . $post_id) . '">View Submission</a>';
    } else if ($column_name == 'read') {
        if ($read = get_post_meta($post_id, 'sb_divi_cfd_read', true)) {
            echo '<span style="color: green;">' . $read['by_name'] . '<br />' . date('Y-m-d H:i', $read['on']) . '</span>';
        } else {
            echo '<span class="dashicons dashicons-email-alt"></span>';
        }
    } else if ($column_name == 'sub_on') {
        if ($data['extra']['submitted_on']) {
            echo '<a href="' . get_permalink($data['extra']['submitted_on_id']) . '">' . $data['extra']['submitted_on'] . '</a>';
        }
    } else if ($column_name == 'sub_date') {
        echo $contact->post_date;
    } else if ($column_name == 'cloned') {
        if ($cloned = get_post_meta($post_id, 'sb_divi_cfd_cloned', true)) {
            $cloned_count = count($cloned);

            echo '<span class="dashicons dashicons-yes"></span> (' . $cloned_count . ')';
        } else {
            echo '<span class="dashicons dashicons-no-alt"></span>';
        }
    } else if ($column_name == 'email') {
        if ($email = get_post_meta($post_id, 'sb_divi_cfd_email', true)) {
            $email = '<a href="mailto:' . $email . '" target="_blank">' . $email . '</a>';
        } else {
            $email = '-';
        }
        echo $email;
    }
}

function sb_divi_cfd_admin_head()
{
    global $current_user;

    if (isset($_GET['sb-action'])) {
        $action = $_GET['sb-action'];

        if ($action == 'mark-all-read') {
            $args = array(
                'posts_per_page' => -1,
                'meta_key' => 'sb_divi_cfd_read',
                'meta_value' => 0,
                'post_type' => 'divi_cf_db',
                'post_status' => 'publish',
            );

            if ($other_contacts = get_posts($args)) {
                foreach ($other_contacts as $other_contact) {
                    $read = array('by_name' => $current_user->display_name, 'by' => $current_user->ID, 'on' => time());
                    update_post_meta($other_contact->ID, 'sb_divi_cfd_read', $read);
                }
            }
        }
    }

    //to hide add new controls
    global $current_screen;

    //print_r($current_screen);

    if ($current_screen->id == 'edit-divi_cf_db') {
        echo '<style>
                    .page-title-action
                    , .row-actions .inline 
                    { 
                        display: none; 
                    }
                </style>';
    } else if ($current_screen->id == 'divi_cf_db') {
        echo '<style>
                    #post-body-content, .page-title-action, #postbox-container-1 { display: none; }
                </style>';
    }

}

function sb_divi_cfd_admin_notice()
{
    if (!current_user_can('administrator')) {
        return;
    }

    if ($sb_divi_cfd = get_option('sb_divi_cfd')) {
        if ($sb_divi_cfd['disable_admin_nag'])
        {
            return;
        }
    }



    $args = array(
        'posts_per_page' => -1,
        'meta_key' => 'sb_divi_cfd_read',
        'meta_value' => 0,
        'post_type' => 'divi_cf_db',
        'post_status' => 'publish',
    );

    if ($other_contacts = get_posts($args)) {
        //Use notice-warning for a yellow/orange, and notice-info for a blue left border.
        $class = 'notice notice-error is-dismissible';
        $message = __('You have ' . count($other_contacts) . ' unread contact form submissions. Click <a href="' . admin_url('edit.php?post_type=divi_cf_db') . '">here</a> to visit them or click <a href="' . admin_url('edit.php?post_type=divi_cf_db&sb-action=mark-all-read') . '">here</a> to mark all as read', 'sb_divi_cfd');

        printf('<div class="%1$s"><p>%2$s</p></div>', $class, $message);
    }
}

function sb_divi_cfd_register_meta_box()
{
    add_meta_box('sb_divi_cfd', esc_html__('Form Submission', 'sb_divi_cfd'), 'sb_divi_cfd_meta_box_callback', 'divi_cf_db', 'normal', 'high');
    add_meta_box('sb_divi_cfd_extra', esc_html__('Extra Information', 'sb_divi_cfd'), 'sb_divi_cfd_meta_box_callback_extra', 'divi_cf_db', 'normal', 'high');
    add_meta_box('sb_divi_cfd_actions', esc_html__('Actions', 'sb_divi_cfd'), 'sb_divi_cfd_meta_box_callback_actions', 'divi_cf_db', 'normal', 'high');
    add_meta_box('sb_divi_cfd_debug', esc_html__('Debug/Server Info', 'sb_divi_cfd'), 'sb_divi_cfd_meta_box_callback_debug', 'divi_cf_db', 'normal', 'high');
}

function sb_divi_cfd_meta_box_callback()
{
    global $current_user;

    $submission = get_post(get_the_ID());

    if (!$read = get_post_meta(get_the_ID(), 'sb_divi_cfd_read', true)) {
        $read = array('by_name' => $current_user->display_name, 'by' => $current_user->ID, 'on' => time());
        update_post_meta(get_the_ID(), 'sb_divi_cfd_read', $read);
    }

    $class = 'notice notice-info';
    $message = 'First read by ' . $read['by_name'] . ' at ' . date('Y-m-d H:i', $read['on']);
    printf('<div class="%1$s"><p>%2$s</p></div>', $class, $message);

    if ($data = get_post_meta(get_the_ID(), 'sb_divi_cfd', true)) {

        if ($fields = $data['data']) {
            echo '<table class="widefat">
                        <thead>
                        <tr>
                            <th>Label</th>
                            <th>Value</th>
                        </tr>
                        </thead>
                        <tbody>';

            foreach ($fields as $field) {
                $value = $field['value'];

                if (is_email($value)) {
                    $value = '<a href="mailto:' . $value . '" target="_blank">' . $value . '</a>';
                }

                echo '<tr>
                            <td><strong>' . $field['label'] . '</strong></td>
                            <td>' . wpautop($value) . '</td>
                        </tr>';
            }

            echo '<tr>
                            <td><strong>Date of Submission</strong></td>
                            <td>' . $submission->post_date . '</td>
                        </tr>';

            echo '</tbody>
                </table>';
        }
    }

}

function sb_divi_cfd_meta_box_callback_extra()
{
    $other_submissions = '';

    if ($data = get_post_meta(get_the_ID(), 'sb_divi_cfd', true)) {
        if ($extra = $data['extra']) {
            echo '<table class="widefat">
                        <thead>
                        <tr>
                            <th>Label</th>
                            <th>Value</th>
                        </tr>
                        </thead>
                        <tbody>';

            foreach ($extra as $key => $value) {

                switch ($key) {
                    case 'submitted_on_id':
                    case 'submitted_by_id':
                        continue(2); //we don't really care about these ones
                        break;
                    case 'submitted_on':
                        if ($extra['submitted_on_id']) {
                            $value = $value . ' (<a href="' . get_permalink($extra['submitted_on_id']) . '" target="_blank">View Page</a> | <a href="' . admin_url('post.php?action=edit&post=' . $extra['submitted_on_id']) . '" target="_blank">Edit Page</a>)';
                        } else {
                            $value = '<em>Unknown</em>';
                        }
                        break;
                    case 'submitted_by':
                        if ($extra['submitted_by_id']) {
                            $value = $value . ' (<a href="' . admin_url('user-edit.php?user_id=' . $extra['submitted_by_id']) . '" target="_blank">View User Profiile</a>';

                            $args = array(
                                'posts_per_page' => -1,
                                'meta_key' => 'sb_divi_cfd_submitted_by',
                                'meta_value' => $extra['submitted_by_id'],
                                'post_type' => 'divi_cf_db',
                                'post_status' => 'publish',
                            );

                            if ($other_contacts = get_posts($args)) {
                                $value .= ' | <a style="cursor: pointer;" onclick="jQuery(\'.other_submissions\').slideToggle();">View ' . count($other_contacts) . ' more submissions by this user</a>';
                                $other_submissions .= '<div style="display: none;" class="other_submissions">
                                                            <h3>Other submissions made by the same person</h3>';
                                $other_submissions .= '<table class="widefat">';

                                foreach ($other_contacts as $other_contact) {
                                    $other_submissions .= '<tr><td><a href="' . admin_url('post.php?action=edit&post=' . $other_contact->ID) . '">' . $other_contact->post_title . '</a></td></tr>';
                                }

                                $other_submissions .= '</table></div>';
                            }

                            $value .= ')';
                        } else {
                            $value = '<em>Not a registered user</em>';
                        }

                        break;
                }

                $key_label = ucwords(str_replace('_', ' ', $key));

                echo '<tr>
                            <td><strong>' . $key_label . '</strong></td>
                            <td>' . $value . '</td>
                        </tr>';
            }

            echo '</tbody>
                </table>';

            echo $other_submissions;
        }

    }

}

function sb_divi_cfd_meta_box_callback_actions()
{
    $submission = get_post(get_the_ID());
    $data = get_post_meta(get_the_ID(), 'sb_divi_cfd', true);

    if (isset($_POST['sb_divi_cfd_map_to'])) {
        $map_to = $_POST['sb_divi_cfd_map_to'];
        $map_to_other = $_POST['sb_divi_cfd_map_to_other'];

        if ($fields = $data['data']) {
            $mapped_fields = array();
            $custom_fields = array();

            foreach ($fields as $field) {
                $mapped_fields[$field['label']] = $field['value'];
            }

            $db_ins = array(
                'post_title' => 'Cloned from contact form',
                'post_content' => 'Cloned from contact form',
                'post_status' => 'draft',
                'post_type' => $_POST['sb_divi_cfd_pt'],
            );

            if (isset($_POST['sb_divi_cfd_date'])) {
                $db_ins['post_date'] = $_POST['sb_divi_cfd_date'];
            }

            $found = 0;

            foreach ($map_to as $key => $field) {
                if ($field) {
                    $found++;

                    if ($field == 'custom_field') {
                        if ($map_to_other[$key]) {
                            $custom_fields[$map_to_other[$key]] = $mapped_fields[$key];
                        }
                    } else {
                        $db_ins[$field] = $mapped_fields[$key];
                    }
                }
            }

            if ($found) {
                // Insert the post into the database
                if ($post_id = wp_insert_post($db_ins)) {
                    if (!is_wp_error($post_id)) {
                        foreach ($custom_fields as $key => $value) {
                            update_post_meta($post_id, $key, $value);
                        }

                        echo '<div id="message" class="updated fade">
                                    <p>Successfully copied the content of this contact form submission to another post type. Click here to <a href="' . get_permalink($post_id) . '">View</a> or <a href="' . admin_url('post.php?action=edit&post=' . $post_id) . '">Edit</a></p>
                                </div>';

                        if (!$cloned = get_post_meta($_GET['post'], 'sb_divi_cfd_cloned', true)) {
                            $cloned = array();
                        }

                        $cloned[$post_id] = time();

                        update_post_meta($_GET['post'], 'sb_divi_cfd_cloned', $cloned);

                    } else {
                        echo '<div id="message" class="error fade">
                                    <p>Oops something went wrong. This error message may be helpful: ' . print_r($post_id, true) . '</p>
                                </div>';
                    }
                }
            } else {
                echo '<div id="message" class="error fade">
                            <p>You need to choose at least one field to map against for the clone to work.</p>
                        </div>';
            }

            //echo '<pre>';
            //print_r($db_ins);
            //print_r($custom_fields);
            //print_r($data['data']);
            //print_r($_POST);
            //echo '</pre>';
        }
    }

    $map_to_options = array();
    $maps = array(
        'post_title' => 'Title'
    , 'post_content' => 'Content'
    , 'custom_field' => 'Custom Field'
    );

    foreach ($maps as $key => $value) {
        $map_to_options[] = '<option value="' . $key . '">' . $value . '</option>';
    }

    $types = get_post_types();
    $type_options = array();

    foreach ($types as $type2) {
        $type_obj2 = get_post_type_object($type2);

        if (!$type_obj2->public) {
            continue;
        }

        $type_options[] = '<option value="' . $type2 . '">' . $type_obj2->labels->name . '</option>';
    }

    echo '<p>';

    if ($email = get_post_meta(get_the_ID(), 'sb_divi_cfd_email', true)) {
        echo '<a style="margin-right: 10px;" class="button-primary" target="_blank" href="mailto:' . $email . '">Reply via Email</a>';
    }

    echo '<a onclick="jQuery(\'.sb_divi_cfd_convert\').slideToggle();" class="button-secondary">Copy to another Post Type</a>';

    echo '</p>';

    ///////////////////////////////////

    echo '<div style="display: none; overflow: scroll;" class="sb_divi_cfd_convert">';

    echo '<h3>Copy to another post type</h3>';

    echo '<p><label>Select Post Type: <select name="sb_divi_cfd_pt">' . implode('', $type_options) . '</select></label></p>';
    echo '<p>Select Field Mappings:</p>';

    echo '<table class="widefat">';

    foreach ($data['fields_original'] as $field) {
        echo '<tr>
                    <td>' . $field['field_label'] . '</td>
                    <td>
                        <select name="sb_divi_cfd_map_to[' . $field['field_label'] . ']"><option value="">-- Unused --</option>' . implode('', $map_to_options) . '</select>
                        <span style="margin-left: 20px; display: inline-block;">(If "Custom Field" selected, enter field name: <input type="text" name="sb_divi_cfd_map_to_other[' . $field['field_label'] . ']" />)</span>
                    </td>
                </tr>';
    }

    echo '</table>';

    echo '<p><label><input type="checkbox" name="sb_divi_cfd_date" value="' . $submission->post_date . '" />&nbsp;Keep date of original submission? (' . $submission->post_date . ')</label></p>';
    echo '<p><input type="submit" class="button-primary sb_divi_cfd_copy" value="Copy" /></p>';

    //echo '<pre>';
    //print_r($data['fields_original']);
    //echo '</pre>';

    echo '</div>';

    if ($cloned = get_post_meta($_GET['post'], 'sb_divi_cfd_cloned', true)) {
        echo '<h3>Clone History</h3>';

        echo '<table class="widefat">
                    <thead>
                        <tr>
                            <th>New Post Title</th>
                            <th>Post Type</th>
                            <th>Date Cloned</th>
                            <th>Actions</th>
                        </tr>
                    </thead>';

        foreach ($cloned as $cloned_id => $date) {
            if ($cloned_post = get_post($cloned_id)) {
                $type_obj = get_post_type_object($cloned_post->post_type);
                $type_name = $type_obj->labels->name;

                echo '<tr>
                            <td>' . $cloned_post->post_title . '</td>
                            <td>' . $type_name . '</td>
                            <td>' . date('Y-m-d H:i', $date) . '</td>
                            <td><a href="' . get_permalink($cloned_id) . '">View</a> | <a href="' . admin_url('post.php?action=edit&post=' . $post_id) . '">Edit</a></td>
                        </tr>';
            }
        }

        echo '</table>';

    }
}

function sb_divi_cfd_meta_box_callback_debug()
{

    if ($data = get_post_meta(get_the_ID(), 'sb_divi_cfd', true)) {
        echo '<div style="display: none; overflow: scroll;" class="sb_divi_cfd_debug">';

        echo '<pre>';
        print_r($data);
        echo '</pre>';

        echo '</div>';

        echo '<p><a onclick="jQuery(\'.sb_divi_cfd_debug\').slideToggle();" class="button-secondary">Reveal Debug/Server Information</a></p>';
    }

}

function sb_divi_cfd_pt_init()
{
    $labels = array(
        'name' => _x('Divi DB - Contact form submissions', 'post type general name', 'sb-divi'),
        'singular_name' => _x('Divi DB', 'post type singular name', 'sb-divi'),
        'menu_name' => _x('Divi DB', 'admin menu', 'sb-divi'),
        'name_admin_bar' => _x('Divi DB', 'add new on admin bar', 'sb-divi'),
        'add_new' => _x('Add New', 'Divi DB', 'sb-divi'),
        'add_new_item' => __('Add New Divi DB', 'sb-divi'),
        'new_item' => __('New Divi DB', 'sb-divi'),
        'edit_item' => __('Edit Divi DB', 'sb-divi'),
        'view_item' => __('View Divi DB', 'sb-divi'),
        'all_items' => __('All Divi DB', 'sb-divi'),
        'search_items' => __('Search Divi DB', 'sb-divi'),
        'parent_item_colon' => __('Parent Divi DB:', 'sb-divi'),
        'not_found' => __('No contact form submissions found.', 'sb-divi'),
        'not_found_in_trash' => __('No contact form submissions found in Trash.', 'sb-divi')
    );

    $args = array(
        'labels' => $labels,
        'description' => __('For storing Divi contact form submissions.', 'sb-divi'),
        'public' => false,
        'publicly_queryable' => false,
        'show_ui' => true,
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => false,
        'capability_type' => 'post',
        'has_archive' => false,
        'hierarchical' => false,
        'menu_position' => null,
        'menu_icon' => 'dashicons-admin-comments',
        'supports' => array('title')
    );

    register_post_type('divi_cf_db', $args);
}

function sb_divi_cfd_et_contact_page_headers($headers, $contact_name, $contact_email)
{
    global $current_user;

    $et_pb_contact_form_num = 0;
    $current_form_fields = isset($_POST['et_pb_contact_email_fields_' . $et_pb_contact_form_num]) ? $_POST['et_pb_contact_email_fields_' . $et_pb_contact_form_num] : '';

    if ($current_form_fields) {
        $data = array();
        $fields_data_json = str_replace('\\', '', $current_form_fields);
        $fields_data_array = json_decode($fields_data_json, true);
        $email = false;

        foreach ($fields_data_array as $index => $value) {
            $value2 = isset($_POST[$value['field_id']]) ? $_POST[$value['field_id']] : '-';
            $label = $value['field_label'];

            if ($value['field_type'] == 'email') {
                $email = $value2;
            }

            $data[] = array('label' => $label, 'value' => $value2);
        }

        $this_page = get_post(get_the_ID());
        $this_user = false;

        if ($this_user_id = (isset($current_user->ID) ? $current_user->ID : 0)) {
            if ($this_user = get_userdata($this_user_id)) {
                $this_user = $this_user->display_name;
            }
        }

        $extra = array(
            'submitted_on' => $this_page->post_title
        , 'submitted_on_id' => $this_page->ID
        , 'submitted_by' => $this_user
        , 'submitted_by_id' => $this_user_id
        );

        $db_ins = array(
            'post_title' => date('Y-m-d H:i:s'),
            'post_status' => 'publish',
            'post_type' => 'divi_cf_db',
        );

        // Insert the post into the database
        if ($post_id = wp_insert_post($db_ins)) {
            update_post_meta($post_id, 'sb_divi_cfd', array('data' => $data, 'extra' => $extra, 'fields_original' => $fields_data_array, 'post' => $_POST, 'server' => $_SERVER));

            if ($this_user_id) {
                update_post_meta($post_id, 'sb_divi_cfd_submitted_by', $this_user_id);
            }

            update_post_meta($post_id, 'sb_divi_cfd_read', 0);
            update_post_meta($post_id, 'sb_divi_cfd_email', $email);
        }

    }

    return $headers;
}

?>